'----------------------------------------------------------------------------
'     MODULE NAME:   BugDetectionForCreateObject.vbs
'
'         $Author:   USER "Dennis"  $
'       $Revision:   1.2  $
'           $Date:   10 Jun 2004 17:37:00  $
'        $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/BugDetectionForCreateObject.VBS.pvcs  $
'
'     DESCRIPTION:   Looks for sundry Windows CreateObject issues.
'----------------------------------------------------------------------------


'--- Initialization ---------------------------------------------------------
dim ErrorCnt   : ErrorCnt = 0
dim OkCnt      : OkCnt    = 0
dim Msg        : Msg      = ""
dim PgmVersion : PgmVersion = "04.159"

'--- Check ------------------------------------------------------------------
CheckObject("WScript.Shell")
CheckObject("WScript.Network")
CheckObject("Scripting.FileSystemObject")
CheckObject("Scripting.Dictionary")
CheckObject("Shell.Application")
CheckObject("WindowsInstaller.Installer")



'--- Report -----------------------------------------------------------------
if  ErrorCnt = 0 then
    if Wscript.Arguments.Count = 1 then if ucase(Wscript.Arguments(0)) = "SILENT" then wscript.quit(0)
    Icon = vbInformation
    Msg  = "No problems located while checking the following " & OkCnt & " objects:" & Msg
else
    Icon = vbCritical
    Msg = "Found " & ErrorCnt & " error(s) while checking the following objects:" & Msg
end if
MsgBox Msg, Icon, "CreateObject() Checks - v" & PgmVersion


'--- Finish up --------------------------------------------------------------
set oFile  = Nothing
set oDir  = Nothing



'============================================================================
sub CheckObject(ObjectName)
'============================================================================
    on error resume next
    Msg = Msg & vbCRLF & vbCRLF & ObjectName & " : "
    dim Obj : set Obj = CreateObject(ObjectName)
    if  err.number = 0 then
        Msg   = Msg & "OK"
        OkCnt = OkCnt + 1
    else
        Msg      = Msg & "FAILED, rc = 0x" & hex(err.number) & " - " & err.description
        ErrorCnt = ErrorCnt + 1
    end if
    set Obj = Nothing
end sub

